<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://vedubox.com
 * @since             1.0.0
 * @package           Vedubox_Marketplace
 *
 * @wordpress-plugin
 * Plugin Name:       Vedubox Marketplace
 * Plugin URI:        https://vedubox.com/wp-vedubox-marketplace
 * Description:       Vedubox Marketplace Plugin for course sale and sso
 * Version:           1.0.0
 * Author:            Veduboz development Team
 * Author URI:        https://vedubox.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       vedubox-marketplace
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'VEDUBOX_MARKETPLACE_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-vedubox-marketplace-activator.php
 */
function activate_vedubox_marketplace() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-vedubox-marketplace-activator.php';
	Vedubox_Marketplace_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-vedubox-marketplace-deactivator.php
 */
function deactivate_vedubox_marketplace() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-vedubox-marketplace-deactivator.php';
	Vedubox_Marketplace_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_vedubox_marketplace' );
register_deactivation_hook( __FILE__, 'deactivate_vedubox_marketplace' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-vedubox-marketplace.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_vedubox_marketplace() {

	$plugin = new Vedubox_Marketplace();
	$plugin->run();

}
run_vedubox_marketplace();
