<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://vedubox.com
 * @since      1.0.0
 *
 * @package    Vedubox_Marketplace
 * @subpackage Vedubox_Marketplace/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Vedubox_Marketplace
 * @subpackage Vedubox_Marketplace/includes
 * @author     Veduboz development Team <erdemtopsakal@etgigrup.com>
 */
class Vedubox_Marketplace_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'vedubox-marketplace',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
